(* x-util.sig *)

(* Copyright (C) 2001 Alley Stoughton

   This file is part of Version 0 of an SML/NJ library for the
   pretty-printing of possibly infinite syntax trees.  See the file
   COPYING for copying and usage restrictions. *)

signature X_UTIL =
sig

val openDisplay : string option -> Widget.root

datatype f_w_font_inf =
           FWFontInf of
             {asc  : int,
              des  : int,
              font : EXeneBase.font,
              ht   : int, wid : int}

val fWFontInf : EXeneBase.font -> f_w_font_inf

val coorToPt : f_w_font_inf -> FlexText.coor  -> Geometry.point
val ptToCoor : f_w_font_inf -> Geometry.point -> FlexText.coor

datatype draw_in =
           DrawIn of
             {hghlt : bool,
              pt    : Geometry.point,
              str   : string}

val draw :
      EXeneBase.font * EXeneWin.window * EXeneBase.color * EXeneBase.color ->
      draw_in -> unit

val coorDraw :
      f_w_font_inf * EXeneWin.window * EXeneBase.color * EXeneBase.color ->
      FlexText.coor_draw_in -> unit

val coorRectToRect : f_w_font_inf -> FlexText.coor_rect -> Geometry.rect
val rectToCoorRect : f_w_font_inf -> Geometry.rect      -> FlexText.coor_rect

end;
