(* select.sig *)

(* Copyright (C) 2001, 2004 Alley Stoughton

   This file is part of Version 0 of an SML/NJ library for the
   pretty-printing of possibly infinite syntax trees.  See the file
   COPYING for copying and usage restrictions. *)

(* a simplified interface to eXene's selection server *)

signature SELECT =
sig

(* set(win, time, str) tries to make the window win be the owner of
   the (primary) selection and arrange that clients who ask for the
   string value of the selection will be given str; win should be the
   window in which the user asked for this action to be taken, and
   time should be the time at which this request was made

   set returns an event that will become enabled, if trying to acquire
   ownership of the selection fails, or, later on, if a window/client
   acquires ownership of the selection (perhaps by calling set) or a
   release is done

   if win is destroyed, though, the event returned by set won't be
   enabled until another set or a release is done *)

val set : EXeneBase.window * EXeneBase.XTime.time * string -> unit CML.event

(* release the selection; this is safe even if the caller doesn't own
   the selection *)

val release : unit -> unit

(* getEvt(win, time) returns an event for getting the string value of
   the primary selection; win should be the window in which the user
   requested the value of the selection, and time should be the time
   at which this request was made

   synchronizing with the event will return NONE, if no client
   currently owns the selection, or the client owning the selection
   couldn't convert it to a string, and will return SOME of the string
   value of the selection, otherwise *)

val getEvt : EXeneBase.window * EXeneBase.XTime.time -> string option CML.event

(* get is the same as sync o getEvt *)

val get : EXeneBase.window * EXeneBase.XTime.time -> string option

end;
