(* pretty.sig *)

(* Copyright (C) 2001 Alley Stoughton

   This file is part of Version 0 of an SML/NJ library for the
   pretty-printing of possibly infinite syntax trees.  See the file
   COPYING for copying and usage restrictions. *)

signature PRETTY =
sig

type block and entry

val block : (unit -> bool * entry list) -> block

val entry : {space  : int,
             indent : int,
             befor  : string,
             block  : block,
             after  : string} ->
            entry

val blockToFlex : char * string * block -> FlexText.flex

val empty : block

val strEntry : string -> entry

val entryBlock : entry -> block

val strBlock : string -> block

end;
