(* flex-text.sig *)

(* Copyright (C) 2001 Alley Stoughton

   This file is part of Version 0 of an SML/NJ library for the
   pretty-printing of possibly infinite syntax trees.  See the file
   COPYING for copying and usage restrictions. *)

signature FLEX_TEXT =
sig

datatype flex = Flex of int * int -> text
and      text = Text of (char * flex option) vector vector

type part  (* partial text *)

val numRows           : part                    -> int
val nullChars         : part                    -> bool
val rmCharsOrRow      : part                    -> part
val empty             : part
val endRow            : part                    -> part
val addCharsOfStr     : part * string           -> part
val addSpaces         : part * int              -> part
val addElision        : part * char * flex      -> part
val complete          : part                    -> text

datatype coor = Coor of {x : int, y : int}

val coorLexLt  : coor * coor -> bool
val coorLexGt  : coor * coor -> bool
val coorLexLte : coor * coor -> bool
val coorLexGte : coor * coor -> bool

val width      : text        -> int
val height     : text        -> int
val sub        : text * coor -> char * flex option
val onEllipsis : text * coor -> bool

datatype coor_draw_in =
           CoorDrawIn of
             {hghlt : bool,
              coor  : coor,
              str   : string}

(* ordered; low is inclusive, hgh is not; coorLexLte(low, hgh) holds *)
datatype sel = Sel of {low : coor, hgh : coor}

val mkSel             : coor * coor             -> sel
val extractSel        : text * sel              -> string
val instrsOfSel       : bool * int * text * sel -> coor_draw_in list
val instrsToAdjustSel : int * text * sel * sel  -> coor_draw_in list

datatype coor_rect =
           CoorRect of
             {ht  : int,
              wid : int,
              x   : int,
              y   : int}

val instrsOfCoorRect  : text * sel * coor_rect  -> coor_draw_in list

end;
