(* simp-fun.sig *)

(* Copyright (C) 2001 Alley Stoughton

   This file is part of Version 0 of an SML/NJ library for the
   pretty-printing of possibly infinite syntax trees.  See the file
   COPYING for copying and usage restrictions. *)

signature SIMP_FUN =
sig

type 'a thunk = unit -> 'a

datatype exp = Id   of string
             | Num  of string
             | Abs  of string * exp thunk
             | App  of exp * exp thunk
             | Cond of exp thunk * exp thunk * exp thunk
             | List of exp thunk list

val abs  : string * exp    -> exp
val app  : exp * exp       -> exp
val cond : exp * exp * exp -> exp
val list : exp list        -> exp

val pretty : exp -> Pretty.block

end;
