(* examps.sml *)

(* Copyright (C) 2001 Alley Stoughton

   This file is part of Version 0 of an SML/NJ library for the
   pretty-printing of possibly infinite syntax trees.  See the file
   COPYING for copying and usage restrictions. *)

structure Examps :> EXAMPS =
struct

open SimpFun

val exp0 = abs("x0", abs("x1", Id "x2"))

val exp1 = app(app(app(Id "x0", Id "x1"), Id "x2"), Id "x3")

val exp2 =
      cond(cond(Id "x0", Id "x1", Id "x2"),
           cond(Id "x3", Id "x4", Id "x5"),
           cond(Id "x6", Id "x7", Id "x8"))

val exp3 =
      list[app(app(Id "x0", Id "x1"), Id "x2"),
           app(app(Id "x3", Id "x4"), Id "x5"),
           app(app(Id "x6", Id "x7"), Id "x8"),
           app(app(Id "x9", Id "x10"), Id "x11")]

val exp4 =
      cond(app(app(Id "x0", Id "x1"), app(Id "x2", Id "x3")),
           list[list[Id "x4",
                     app(Id "x5", Num "6"),
                     abs("x7", app(Id "x8", Id "x9"))],
                cond(Id "x10",
                     Id "x11",
                     Num "12"),
                abs("x13", Id "x14")],
           app(abs("x15", Id "x16"),
               Id "x17"))

local
  fun id n = Id("x" ^ Int.toString n)

  fun f n =
        Cond(fn () => app(app(app(id n, id(n + 1)), id(n + 2)), id(n + 3)),
             fn () => list[id(n + 4), id(n + 5), id(n + 6), id(n + 7)],
             fn () => f(n + 8))
in
  val exp5 = f 0
end

local
  fun id bs =
        Id("x" ^
           concat(map (fn false => "0"
                        | true  => "1")
                       bs))

  fun f bs =
        Cond(fn () => id bs,
             fn () => f(bs @ [false]),
             fn () => f(bs @ [true]))
in
  val exp6 = f nil
end

val examps = [exp0, exp1, exp2, exp3, exp4, exp5, exp6]

end;
