/* parser.y */

/* Allen Stoughton -- 1993 */

%{
#include "interface.h"
%}

%start problem

%token IOTA FUNCTIONS CONSTANTS TESTS

%token Elem Fun Var

%%

problem: iota_sect funs_sect cons_sect tests_sect
  ;

iota_sect:
    IOTA elem_seq
      { iota_sect_act(); }
  ;

elem_seq:
    /* empty */
  | elem_seq elem
  ;

elem:
    Elem
      { elem_act($1); }
  ;

funs_sect:
    FUNCTIONS fun_seq
  ;

fun_seq:
    /* empty */
  | fun_seq fun
  ;

fun:
    fun_name clause_seq
      { fun_act(); }
  ;

fun_name:
    Fun
      { fun_name_act($1); }
  ;

clause_seq:
    /* empty */
  | clause_seq clause
  ;

clause:
    pat_seq '=' pats_end result
      { clause_act(); }
  ;

pat_seq:
    /* empty */
  | pat_seq pat
  ;

pat:
    Elem
      { pat_elem_act($1); }
  | Var
      { pat_var_act($1); }
  | '_'
      { pat_wildcard_act(); }
  ;

pats_end:
    /* empty */
      { pats_end_act(); }
  ;

result:
    Elem
      { result_elem_act($1); }
  | Var
      { result_var_act($1); }
  ;

cons_sect:
    CONSTANTS con_seq
  ;

con_seq:
    /* empty */
  | con_seq con
  ;

con:
    Elem
      { con_elem_act($1); }
  | Fun
      { con_fun_act($1); }
  ;

tests_sect:
    TESTS test_seq
      { tests_sect_act(); }
  ;

test_seq:
    /* empty */
  | test_seq test
  ;

test:
    test_arg_seq '=' test_arg_seq_end test_result
      { test_act(); }
  ;

test_arg_seq:
    /* empty */
  | test_arg_seq test_arg
  ;

test_arg:
    Elem
      { test_arg_elem_act($1); }
  | Fun
      { test_arg_fun_act($1); }
  ;

test_arg_seq_end:
    /* empty */
      { test_arg_seq_end_act(); }
  ;

test_result:
    Elem
      { test_result_act($1); }
  ;

%%

#include "lexer.c"
