 /* lexer.l */

 /* Allen Stoughton -- 1994 */

elem        [A-Z0-9]

fun         [A-Z][a-zA-Z0-9]+

var         [a-z][a-z0-9]*

comment     #.*

%%

iota        return IOTA;

functions   return FUNCTIONS;

constants   return CONSTANTS;

tests       return TESTS;

{elem}      { yylval = make_elem(yytext); return Elem; }

{fun}       { yylval = make_fun(yytext); return Fun; }

{var}       { yylval = make_var(yytext); return Var; }

\n    	    { line_num++; }

[ \t] 	    ;

{comment}   ;

.           return yytext[0];
