/* interface.h */

/* Allen Stoughton -- 1994 */

/* Interface between main.c, lexer.l and parser.y */

#include <stdio.h>

#ifdef FLEX  /* see Makefile */
extern char *yytext;
#else
extern char yytext[];
#endif

extern FILE *yyin;
void yyerror(const char *msg);
int yyparse(void);
int yywrap(void);

extern int line_num;

int make_elem(char *s);
int make_fun(char *s);
int make_var(char *s);

void iota_sect_act(void);
void elem_act(int elem);
void fun_act(void);
void fun_name_act(int fun);
void clause_act(void);
void pat_elem_act(int elem);
void pat_var_act(int var);
void pat_wildcard_act(void);
void pats_end_act(void);
void result_elem_act(int elem);
void result_var_act(int var);
void con_elem_act(int elem);
void con_fun_act(int fun);
void tests_sect_act(void);
void test_act(void);
void test_arg_elem_act(int elem);
void test_arg_fun_act(int fun);
void test_arg_seq_end_act(void);
void test_result_act(int elem);
