/* charstoc.c */

/* Allen Stoughton -- 1993 */

/* charstoc (characters to C) take a C identifer, id, as its single
   argument, and generates two C declarations on its standard output.
   The first consists of an array of constant characters called id whose
   elements are the characters in charstoc's standard input.  The second
   is an integer variable called id_size whose value is the number
   of bytes in the array id.  The standard input of charstoc must be
   nonempty (since arrays in C must be nonempty).

   For example, the shell command

     charstoc x < input

   will produce the declarations

     const char x[] = {
       97, 98, 99, 100, 101, 102, 103, 104, 105, 106,
       107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
       117, 118, 119, 120, 121, 122
     };

     int x_size = 26;

   if the file input consists of the characters a-z */

#include <stdio.h>

#define ElmtsPerLine 10

int main(int argc, char **argv)
{
  int c, n;

  if (argc != 2) {
    fprintf(stderr, "usage: charstoc id\n");
    return 1;
  }

  if ((c = getchar()) == EOF) {
    fprintf(stderr, "charstoc: empty standard input\n");
    return 1;
  }

  n = 1;
  printf("const char %s[] = {\n  %d", argv[1], c);

  while ((c = getchar()) != EOF) {
    putchar(',');
    if (n % ElmtsPerLine == 0)
      printf("\n  ");
    else
      putchar(' ');
    printf("%d", c);
    n++;
  }

  printf("\n};\n\nint %s_size = %d;\n", argv[1], n);

  return 0;
}
