(* selection-sig.sml
 *
 * created ddeboer, 2005, from selection.sml, which is:
 * COPYRIGHT (c) 1994 by AT&T Bell Laboratories.  See COPYRIGHT file for details.
 *
 * A window-level view of the low-level selection operations.
 *
 *)

signature SELECTION = sig

    type selection_handle
    type atom (* = XProtTypes.atom *)
    type time (* = XTime.time *)

  (** Selection owner operations **)

    val acquireSelection : (Window.window * atom * time) -> selection_handle option

    val selectionOf : selection_handle -> atom
    val timeOf      : selection_handle -> time

    val selectionReqEvt : selection_handle -> {
        target : atom,
        time : time option,
        reply : XProtTypes.prop_val option -> unit,
    (* modified by ddeboer to include property of request
     * (for requests such as multiple where the property contains
     * information the owner needs to process the request) *)
        win : XProtTypes.win_id,
        property : atom
      } CML.event
    (* this event is enabled once for each request for the selection.  The
     * target field is the requested target type; the time field is the
     * server-time of the gesture that caused the request, and the reply
     * field is a function for sending the reply.
     *)

    val selectionRelEvt : selection_handle -> unit CML.event
    (* this event becomes enabled when the selection is lost; either by
     * the owner releasing it, or by some other client acquiring ownership.
     *)

    val releaseSelection : selection_handle -> unit
    (* release ownership of the selection *)


  (** Selection requestor operations **)

    val requestSelection : {
        win : Window.window,
        selection : atom,
        target : atom,
        property : atom,
        time : time
      } -> XProtTypes.prop_val option CML.event
    (* request the value of the selection. the win field is the requesting
     * window, the selection field is the requested selection, the target
     * field is the requested target type, and the time field is the server-
     * time of the gesture causing the request.  This returns an event
     * that will become enabled when the reply is received.
     *)
   
  end; (* Selection-sig *)
