(* swap-channel.sml *)

(* swap channels *)

structure SwapChannel :> SWAP_CHANNEL =
struct

open CML

type 'a swap_chan = ('a * 'a chan)chan

val swapChannel = channel

fun swapEvt(swapCh, x) =
      guard(fn () =>
                 choose[wrap(recvEvt swapCh,
                             fn (y, replyCh) => (send(replyCh, x); y)),

                        let val replyCh = channel()
                        in wrap(sendEvt(swapCh, (x, replyCh)),
                                fn () => recv replyCh)
                        end])

end;
