(* susp.sml *)

(* implementation of suspensions *)

structure Susp :> SUSP =
struct

datatype 'a delay = Value of 'a
                  | Delay of unit -> 'a

type 'a susp = 'a delay ref

fun delay f = ref(Delay f)

fun force(ref(Value x))      = x
  | force(r as ref(Delay f)) =
      let val x = f()
      in r := Value x; x end

end;
