(* susp.sig *)

(* interface of suspensions *)

signature SUSP =
sig

(* a value of type 'a susp is a SUSPENSION of type 'a, i.e., a mutable
   data structure that initially contains a function f of type unit ->
   'a, but that, once forced, will contain the value f() *)

type 'a susp

(* delay f creates a suspension whose contents is f *)

val delay : (unit -> 'a) -> 'a susp

(* force s forces the suspension s and then return its contents *)

val force : 'a susp -> 'a

end;
