(* sieve.sig *)

(* interface of infinite version of Sieve of Eratosthenes *)

signature SIEVE =
sig

(* infinite streams of values of type 'a *)

type 'a stream

(* if n >= 0, then split(s, n) returns the pair (xs, t), where xs is
   the first n elements of s, and t is the remainder of s *)

val split : 'a stream * int -> 'a list * 'a stream

(* primes is the stream of all prime numbers, in ascending order *)

val primes : int stream

end;
